*! version 5.0
* 13 August 2018
* NIDS
* Master Wealth do file for Nids Wave 2

* THIS IS 6th WEALTH DO FILE - RELEASE DO FILE: 6 OF 6
* THIS DO FILE PRODUCES THE VARIABLES AS THEY APPEAR IN THE PUBLIC RELEASE

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Wealth do file (1 of 6)"

version 12.0
*=====================================================================================================================================

* OPENING DATASET CREATED IN DO FILE "Wealth - Aggregation of imputation variables (5 of 6)"

use "$DataOUT\hhwealth.dta", clear

*-------------------------------------------------------------------------------------------------------------------------------------

lab var re_ass "Real Estate Assets"
lab var re_deb "Real Estate Debts"
lab var pi_re_ass "Pre-imputation Real Estate Assets"
lab var pi_re_deb "Pre-imputation Real Estate Debts"
lab var pi_b_ass "Pre-imputation Business Assets"
lab var pi_v_ass "Pre-imputation Vehicle Assets"
lab var pi_f_ass "Pre-imputation Financial Assets"
lab var pi_s_ass "Pre-imputation Retirement Annuity Assets"
lab var pi_lvstk_ass "Pre-imputation Livestock Assets"
lab var pi_b_deb "Pre-imputation Business Debts"
lab var pi_v_deb "Pre-imputation Vehicle Debts"
lab var pi_f_deb "Pre-imputation Financial Debts"
lab var b_ass "Business Assets"
lab var v_ass "Vehicle Assets"
lab var f_ass "Financial Assets"
lab var s_ass "Superannuation Assets"
lab var b_deb "Business Debts"
lab var v_deb "Vehicle Debts"
lab var f_deb "Financial Debts"
lab var lvstk_ass "Livestock Assets"
lab var pi_tot_ass "Pre-imputation Total Assets"
lab var pi_tot_deb "Pre-imputation Total Debts"
lab var tot_ass "Total Assets"
lab var tot_deb "Total Debts"
lab var pi_net_worth "Pre-imputation Net Worth"
lab var hhq_networth "HH One-shot Net Worth"
lab var net_worth "Net Worth"

order w2_hhid re_ass b_ass v_ass f_ass s_ass lvstk_ass tot_ass re_deb b_deb v_deb f_deb tot_deb pi_re_ass ///
pi_b_ass pi_v_ass pi_f_ass pi_s_ass pi_lvstk_ass pi_tot_ass pi_b_deb pi_v_deb pi_f_deb pi_tot_ass ///
pi_re_deb pi_b_deb pi_v_deb pi_f_deb pi_tot_deb hhq_networth pi_net_worth net_worth

********************************************************************

foreach var of varlist re_ass-net_worth {
rename `var' w2_`var'
}

compress
duplicates drop w2_hhid, force
save "$DataOUT\hhwealth_$VersionOUT", replace

erase "$DataOUT\hhwealth.dta"
erase "$DataOUT\impdata.dta"
erase "$DataOUT\prepdata.dta"
erase "$DataOUT\data.dta"

* end of do file
*==================================================================================================================================================
